/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.adapters.QuestSchemeAdapter;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionLoader;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.util.ILogHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public final class QuestManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<ResourceLocation, QuestScheme<?>> quests = new HashMap();
    private final ILogHandler log;
    private final QuestSchemeAdapter adapter;

    public QuestManager(ILogHandler handler, QuestConditionLoader loader) {
        super(GSON, "quest/quests");
        this.log = handler;
        this.adapter = new QuestSchemeAdapter(loader);
    }

    public <D extends IQuestData> QuestScheme<D> getScheme(ResourceLocation id) {
        return this.quests.get(id);
    }

    public Set<ResourceLocation> getQuestIds() {
        return this.quests.keySet();
    }

    public Set<QuestScheme<?>> getSchemes(int count, float reputation) {
        ReputationStatus status = ReputationStatus.getStatus(reputation);
        int maxTier = status.getBaseTier();
        LinkedList schemePool = new LinkedList();
        this.quests.values().stream().filter(scheme -> !scheme.isSpecialTaskQuest() && scheme.getTier() <= maxTier).forEach(schemePool::add);
        HashSet results = new HashSet();
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            int schemeIndex = random.nextInt(schemePool.size());
            results.add((QuestScheme<?>)schemePool.get(schemeIndex));
            schemePool.remove(schemeIndex);
        }
        return results;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, IResourceManager resourceManager, IProfiler profiler) {
        try {
            this.log.info("Loading quests", new Object[0]);
            this.quests.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
                ResourceLocation id = entry.getKey();
                JsonElement data = entry.getValue();
                try {
                    QuestScheme scheme = this.adapter.resolveQuestFile(id, data);
                    this.quests.put(id, scheme);
                }
                catch (JsonParseException e) {
                    this.log.err("Failed loading of quest: {}, invalid JSON: {}", id.toString(), e.getMessage());
                }
            }
            this.log.info("Quests loaded, total {} quests", this.quests.size());
        }
        catch (JsonParseException e) {
            this.log.err("Could not load quests, JSON exception ocurred: {}", e.toString());
        }
        catch (Exception e) {
            this.log.fatal("Fatal error ocurred while loading quests: {}", e.toString());
        }
    }
}

